
Class PhysicsTri

	Public
	
	Property TriBody:RigidBody ()
		Return body
	End
	
	Method New ()
	
		If Not PhysicsTriList Then PhysicsTriList = New List <PhysicsTri>
		PhysicsTriList.AddLast (Self)
		
	End

	Method Destroy:Void ()
		model?.Destroy ()
		If body Then body = Null
	End

	Function Explode (rocket:Rocket)

		Local model:Model = rocket.RocketModel
		Local body:RigidBody = rocket.RocketBody
		
		For Local mat:Int = 0 Until model.Mesh.NumMaterials
		
			For Local loop:UInt = 0 Until model.Mesh.GetIndices (mat).Length Step 3 * TRI_SKIPPER ' Set in consts.monkey2
				
				Local ptri:PhysicsTri		= New PhysicsTri
				
				ptri.model					= ptri.ModelFromTriangle (model, loop, mat)
				
				ptri.model.Parent			= Null
				ptri.model.CastsShadow		= False

				ptri.collider				= ptri.model.AddComponent <BoxCollider> ()
				ptri.collider.Box			= ptri.model.Mesh.Bounds
				
				ptri.body					= ptri.model.AddComponent <RigidBody> ()
				ptri.body.Mass				= 1.0
				ptri.body.Restitution		= 0.25
				ptri.body.Friction			= 0.5
				ptri.body.AngularDamping	= 1.0
				
				ptri.body.CollisionMask		= COLL_TRI
				ptri.body.CollisionGroup	= TRI_COLLIDES_WITH
				
				' Tri centre...
				
				Local centroid:Vec3f	= (ptri.model.Mesh.GetVertex (0).position + ptri.model.Mesh.GetVertex (1).position + ptri.model.Mesh.GetVertex (2).position) / 3.0

				' Tri position relative to model centre, range 0-1...
				
				Local core_vec:Vec3f	= ((model.Position + centroid) - model.Position).Normalize ()
				
				' Add velocity...
				
				Local with_vel:Vec3f	= body.LinearVelocity + core_vec * Rnd (1.0, 5.0)

				' Boom!
				
				ptri.body.ApplyImpulse (with_vel)
				
				' Crumble!
				' ptri.body.ApplyImpulse (body.LinearVelocity)

				' Circular!
				' Local power:Float = 5.0
				' ptri.body.ApplyImpulse (body.LinearVelocity + (model.Basis * New Vec3f (Rnd (-1.0, 1.0), Rnd (-1.0, 1.0), Rnd (-1.0, 1.0))).Normalize () * power)

			Next
		
		Next

	End
	
	Function Clear ()

		If PhysicsTri.PhysicsTriList

			For Local pt:PhysicsTri = Eachin PhysicsTri.PhysicsTriList
				pt.Destroy ()
			Next

			PhysicsTri.PhysicsTriList.Clear ()

		Endif

	End
	
	Private

	Global PhysicsTriList:List <PhysicsTri>
	
	Field model:Model
	Field body:RigidBody
	Field collider:BoxCollider

	Method ModelFromTriangle:Model (in_model:Model, index:UInt, mat_index:Int)

		Local tri_model:Model = New Model
	
			Assert (mat_index < in_model.Mesh.NumMaterials, "Material index too high")
			Assert (index + 2 < in_model.Mesh.NumIndices, "Index too high") ' Think that's right...
					
			tri_model.Material			= in_model.Materials [mat_index]
			tri_model.Material.CullMode	= CullMode.None

		Local indices:UInt []		= in_model.Mesh.GetIndices (mat_index)

		Local tri_verts:Vertex3f []	= New Vertex3f [3]
		
			' mesh-local co-ords...
			
			tri_verts [0]	= in_model.Mesh.GetVertex (indices [index + 0])
			tri_verts [1]	= in_model.Mesh.GetVertex (indices [index + 1])
			tri_verts [2]	= in_model.Mesh.GetVertex (indices [index + 2])
		
		Local tri_indices:UInt [] = New UInt [3]
		
			tri_indices [0]	= 0
			tri_indices [1]	= 1
			tri_indices [2]	= 2
		
		Local tri_mesh:Mesh	= New Mesh (tri_verts, tri_indices)
		
			tri_mesh.UpdateNormals ()
			tri_mesh.UpdateTangents ()
	 
			tri_model.Mesh		= tri_mesh
	 		tri_model.Parent	= in_model
 		
		Return tri_model
	 
	End
	
End
